%% Code to generate plot 6b
% AoD estimation error without exploiting angle steering

clear all
close all
clc

T_s = 1; no_sim = 10^6;
aspread_set = [ 30 ];

aspread_doa = aspread_set(1);
file_load = ['Fig6b_aspread_',num2str(aspread_doa),...
    'T_s_',num2str(T_s),'no_sim',num2str(no_sim),'.mat'];
load(file_load);

figure
semilogy(SNR_dB, (MSE_sd_dod_det), 'k:','LineWidth',1.2)
hold on

no_sim = 10^6;
aspread_doa = aspread_set(1);
file_load =  ['Fig4c_aspread_',num2str(aspread_doa),...
    'T_s_',num2str(T_s),'no_sim',num2str(no_sim),'.mat'];
load(file_load);


semilogy(SNR_dB, (MSE_sd_dod_det), 'b','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_a_dod_det), 'r--','LineWidth',1.2)


legend( 'SD without angle steering','SD with angle steering','UQ');
xlabel('SNR (dB)')
ylabel('AoD estimation error (E_{\phi})')
grid on
ylim([10^(-4) 1.1])
xlim([-15 15])
legend('location','east')
savefig('Fig6b.fig')
saveas(gcf,'Fig6b','epsc')


